/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.time;

import com.ibm.hwmca.base.time.ConsoleTimeChangeInProgressException;
import com.ibm.hwmca.base.time.ConsoleTimeSetException;
import com.ibm.hwmca.base.time.CustConDateTimeBean;
import com.ibm.hwmca.base.time.CustConDateTimeBeanData;
import com.ibm.hwmca.base.time.ErrorIds;
import com.ibm.hwmca.base.time.MasterTimeSourceExistsException;
import com.ibm.hwmca.base.time.RebootRequiredException;
import com.ibm.hwmca.base.time.TimeManager;
import com.ibm.hwmca.base.util.BaseMessageText;
import com.ibm.hwmca.base.util.BaseMessageTitle;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.msgpanel.CommonMsgInterface;
import com.ibm.hwmca.fw.task.HwmcaPanelTasklet;
import com.ibm.hwmca.fw.task.ProgressCancelListener;
import com.ibm.hwmca.fw.task.ProgressData;
import com.ibm.hwmca.fw.task.ProgressEndedListener;
import com.ibm.hwmca.fw.task.ProgressReportListenerImpl;
import com.ibm.hwmca.fw.task.ProgressStartEvent;
import com.ibm.hwmca.fw.tasklet.PanelTaskletProgressListener;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.tasklet.PanelTaskletResponse;
import com.ibm.hwmca.fw.tasklet.TaskletException;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.MsgType;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.ui.framework.TaskActionEvent;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Calendar;
import java.util.TimeZone;

public class ConsoleTimeTasklet
extends HwmcaPanelTasklet
implements ProgressEndedListener,
ErrorIds {
    private static final String TRACE_MASKT = "XTODTSKT";
    private static final String TRACE_MASKF = "XTODTSKF";
    private static final String TRACE_MASKD = "XTODTSKD";
    private static final String AUIML_FILE_NAME = "com.ibm.hwmca.base.time.res.CustDateTimeRes";
    private static final String PANEL_NAME = "CustConDateTimePanel";
    private boolean progressDismissed = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void service(PanelTaskletRequest request, PanelTaskletResponse response) throws TaskletException {
        block42: {
            Trace.trace("XTODTSKT", "-> service");
            if (request.isInitialRequest()) {
                Trace.trace("XTODTSKF", "Handling initial request");
                bean = new CustConDateTimeBean(this.createBeanDataForCurrentTime());
                Trace.trace("XTODTSKF", "About to request display of initial panel with bean=" + bean);
                response.replace("com.ibm.hwmca.base.time.res.CustDateTimeRes", "CustConDateTimePanel", bean);
                return;
            }
            if (request.isDisposed() || request.isCanceled()) {
                Trace.trace("XTODTSKF", "Termination request; about to call terminate()");
                response.terminate();
                return;
            }
            command = ((TaskActionEvent)request.getData("event")).getActionCommand();
            Trace.trace("XTODTSKF", "command=" + command);
            if (command.equals("CANCEL")) {
                response.terminate();
                return;
            }
            if (!command.equals("CustomizeButton")) break block42;
            tm = TimeManager.getTimeManager();
            beanData = (CustConDateTimeBeanData)request.getData("beanData");
            Trace.trace("XTODTSKF", "beanData from request=" + beanData);
            df = DateFormat.getDateInstance(1);
            date = df.format(beanData.getDateNumber().getTime());
            tf = DateFormat.getTimeInstance(2);
            time = tf.format(beanData.getTimeNumber().getTime());
            direction = beanData.isEastOfGreenwich() != false ? "+" : "-";
            nf = NumberFormat.getInstance();
            nf.setMinimumIntegerDigits(2);
            offsetHours = nf.format(beanData.getHoursNumber());
            offsetMinutes = nf.format(beanData.getMinutesNumber());
            Trace.trace("XTODTSKF", "Date=" + date + "; time=" + time + "; direction=" + direction + "; offsetHours=" + offsetHours + "; offsetMinutes=" + offsetMinutes);
            dtf = DateFormat.getDateTimeInstance(1, 2);
            tz = TimeZone.getTimeZone("GMT" + direction + offsetHours + offsetMinutes);
            dtf.setTimeZone(tz);
            try {
                newTime = dtf.parse(date + " " + time + " GMT" + direction + offsetHours + offsetMinutes);
            }
            catch (ParseException pe) {
                Trace.trace("XTODTSKF", "Got a ParseException: " + pe);
                te = new TaskletException(pe);
                new FrameworkLog(ErrorIds.LOGINFO, 5, te).log();
                throw te;
            }
            Trace.trace("XTODTSKF", "newTime=" + dtf.format(newTime));
            f = DateFormat.getDateTimeInstance(1, 1);
            f.setTimeZone(tz);
            Trace.trace("XTODTSKF", "newTime=" + f.format(newTime));
            Trace.trace("XTODTSKF", "newTime(millis)=" + newTime.getTime());
            newTimeCalendar = Calendar.getInstance(tz);
            newTimeCalendar.setTime(newTime);
            initialText = new BaseMessageTitle("TIMEPROGRESS.TITLE");
            id = "1";
            progressListener = new PanelTaskletProgressListener(this);
            progressStartEvent = new ProgressStartEvent(this.getTask().getUIInfo().getUnlocalizedName(), new ProgressData[]{new ProgressData()}, 0L, (LocalizableText)initialText, id, (ProgressCancelListener)null, (ProgressEndedListener)this);
            timeProgressReportListener = new ProgressReportListenerImpl(id, null, progressListener);
            var23_26 = this;
            synchronized (var23_26) {
                block38: {
                    block41: {
                        block39: {
                            block40: {
                                this.progressDismissed = false;
                                progressPanelUsed = false;
                                try {
                                    progressPanelUsed = tm.requestConsoleTimeSet(newTimeCalendar, progressListener, progressStartEvent, timeProgressReportListener);
                                    if (progressPanelUsed) {
                                        Trace.trace("XTODTSKF", "About to wait for progress panel to be dismissed");
                                        while (!this.progressDismissed) {
                                            try {
                                                this.wait();
                                            }
                                            catch (InterruptedException exc) {
                                                // empty catch block
                                            }
                                        }
                                    } else {
                                        Trace.trace("XTODTSKF", "Time change succeeded; tell the user");
                                        this.showMessageBox(true, new BaseMessageTitle("IQZA0149.TITLE"), new BaseMessageText("IQZA0149.TEXT"), MsgType.INFORMATION_MESSAGE, new LocalizableText[]{CommonMsgInterface.OK_BUTTON});
                                    }
                                    response.update(this.createBeanDataForCurrentTime());
                                    break block38;
                                }
                                catch (ConsoleTimeChangeInProgressException ctcipe) {
                                    Trace.trace("XTODTSKF", "There is already a console time change in progress");
                                    this.showMessageBox(true, new BaseMessageTitle("TIMEINPROG.TITLE"), new BaseMessageText("TIMEINPROG.TEXT"), MsgType.ERROR_MESSAGE, new LocalizableText[]{CommonMsgInterface.OK_BUTTON});
                                    response.noAction();
                                    break block38;
                                }
                                catch (MasterTimeSourceExistsException mtsee) {
                                    Trace.trace("XTODTSKF", "A master time source exists; find it");
                                    object = tm.getMasterTimeSource();
                                    masterTimeSource = null;
                                    if (object != null) {
                                        try {
                                            masterTimeSource = tm.getMasterTimeSourceImpl(object);
                                        }
                                        catch (HException e) {
                                            // empty catch block
                                        }
                                    }
                                    if (masterTimeSource == null) break block39;
                                    this.showMessageBox(true, new BaseMessageTitle("IQZA0375.TITLE"), new BaseMessageText("IQZA0375.TEXT"), MsgType.ERROR_MESSAGE, new LocalizableText[]{CommonMsgInterface.OK_BUTTON});
                                    if (!tm.setTimeChangeInProgress(true)) break block40;
                                    try {
                                        try {
                                            progressPanelUsed = tm.syncConsoleTime(object, masterTimeSource, progressListener, progressStartEvent, timeProgressReportListener, false);
                                            if (progressPanelUsed) {
                                                Trace.trace("XTODTSKF", "About to wait for progress panel to be dismissed");
                                                while (!this.progressDismissed) {
                                                    try {
                                                        this.wait();
                                                    }
                                                    catch (InterruptedException exc) {
                                                        // empty catch block
                                                    }
                                                }
                                            }
                                            response.update(this.createBeanDataForCurrentTime());
                                        }
                                        catch (HException he) {
                                            Trace.trace("XTODTSKF", "Exception on time sync:" + he);
                                            this.showMessageBox(true, new BaseMessageTitle("TIME002.TITLE"), new BaseMessageText("TIME002.TEXT"), MsgType.ERROR_MESSAGE, new LocalizableText[]{CommonMsgInterface.OK_BUTTON});
                                            response.noAction();
                                            var31_44 = null;
                                            tm.setTimeChangeInProgress(false);
                                            break block38;
                                        }
                                    }
                                    catch (Throwable var30_46) {
                                        var31_45 = null;
                                        tm.setTimeChangeInProgress(false);
                                        throw var30_46;
                                    }
                                }
                                catch (RebootRequiredException rre) {
                                    Trace.trace("XTODTSKF", "A reboot is required for this time change");
                                    answer = this.showMessageBox(true, new BaseMessageTitle("TIME001.TITLE"), new BaseMessageText("TIME001.TEXT"), MsgType.QUESTION_MESSAGE, new LocalizableText[]{CommonMsgInterface.YES_BUTTON, CommonMsgInterface.NO_BUTTON});
                                    if (answer.equals(CommonMsgInterface.YES_BUTTON)) {
                                        try {
                                            tm.setSystemTimeAndReboot(newTimeCalendar, null);
                                            response.update(this.createBeanDataForCurrentTime());
                                        }
                                        catch (HException he) {
                                            Trace.trace("XTODTSKF", "Exception on time set:" + he);
                                            this.showMessageBox(true, new BaseMessageTitle("TIME002.TITLE"), new BaseMessageText("TIME002.TEXT"), MsgType.ERROR_MESSAGE, new LocalizableText[]{CommonMsgInterface.OK_BUTTON});
                                            response.noAction();
                                        }
                                        break block38;
                                    } else {
                                        response.noAction();
                                    }
                                    break block38;
                                }
                                catch (ConsoleTimeSetException ctse) {
                                    if (!ctse.isProgressPanelUsed()) break block41;
                                    Trace.trace("XTODTSKF", "About to wait for progress panel to be dismissed");
                                }
                                while (!this.progressDismissed) {
                                    try {
                                        this.wait();
                                    }
                                    catch (InterruptedException exc) {
                                        // empty catch block
                                    }
                                }
lbl152:
                                // 2 sources

                                while (true) {
                                    response.noAction();
                                    break block38;
                                    break;
                                }
                                catch (HException he) {
                                    Trace.trace("XTODTSKF", "An error occurred while setting the console time: " + he);
                                    this.showMessageBox(true, new BaseMessageTitle("TIME002.TITLE"), new BaseMessageText("TIME002.TEXT"), MsgType.ERROR_MESSAGE, new LocalizableText[]{CommonMsgInterface.OK_BUTTON});
                                    response.noAction();
                                    break block38;
                                }
                                var31_43 = null;
                                tm.setTimeChangeInProgress(false);
                                break block38;
                            }
                            Trace.trace("XTODTSKF", "Time change already in progress");
                            this.showMessageBox(true, new BaseMessageTitle("TIMEINPROG.TITLE"), new BaseMessageText("TIMEINPROG.TEXT"), MsgType.ERROR_MESSAGE, new LocalizableText[]{CommonMsgInterface.OK_BUTTON});
                            break block38;
                        }
                        Trace.trace("XTODTSKF", "Master time source is gone before we could sync with it");
                        this.showMessageBox(true, new BaseMessageTitle("TIME002.TITLE"), new BaseMessageText("TIME002.TEXT"), MsgType.ERROR_MESSAGE, new LocalizableText[]{CommonMsgInterface.OK_BUTTON});
                        break block38;
                    }
                    Trace.trace("XTODTSKF", "An error occurred while setting the console time: " + ctse);
                    this.showMessageBox(true, new BaseMessageTitle("TIME002.TITLE"), new BaseMessageText("TIME002.TEXT"), MsgType.ERROR_MESSAGE, new LocalizableText[]{CommonMsgInterface.OK_BUTTON});
                    ** continue;
                }
                return;
            }
        }
        if (command.equals("RefreshButton")) {
            response.update(this.createBeanDataForCurrentTime());
            return;
        }
        Trace.trace("XTODTSKF", "Unrecognized action command: " + command);
        new FrameworkLog(ErrorIds.LOGINFO, 4).log();
        response.noAction();
    }

    public void logException(Throwable throwable) {
        Trace.trace(TRACE_MASKT, "-> logException(" + throwable + ")");
        new FrameworkLog(ErrorIds.LOGINFO, 2, throwable).log();
        Trace.trace(TRACE_MASKT, "<- logException()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void progressEnded(String id) {
        Trace.trace(TRACE_MASKT, "-> progressEnded");
        ConsoleTimeTasklet consoleTimeTasklet = this;
        synchronized (consoleTimeTasklet) {
            this.progressDismissed = true;
            this.notifyAll();
        }
        Trace.trace(TRACE_MASKT, "<- progressEnded");
    }

    private CustConDateTimeBeanData createBeanDataForCurrentTime() {
        Calendar timeCal = Calendar.getInstance();
        int offset = (timeCal.get(15) + timeCal.get(16)) / 60000;
        boolean west = offset < 0;
        offset = Math.abs(offset);
        int hours = offset / 60;
        int minutes = offset % 60;
        Calendar dateCal = Calendar.getInstance();
        dateCal.setTime(timeCal.getTime());
        CustConDateTimeBeanData beanData = new CustConDateTimeBeanData(timeCal, dateCal, hours, minutes, new String[]{west ? CustConDateTimeBean.DIRECTION_CHOICE_WEST : CustConDateTimeBean.DIRECTION_CHOICE_EAST});
        Trace.trace(TRACE_MASKF, "Bean data for current time: " + beanData);
        return beanData;
    }
}

